/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent;

import com.google.common.collect.Lists;
import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipSize;
import com.minecolonies.coremod.util.CreativeRaiderStructureHandler;
import java.util.List;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class ShipBasedRaiderUtils {
    public static final String SHIP_FOLDER = "/ships/";
    private static final int SPAWNER_DISTANCE = 30;

    private ShipBasedRaiderUtils() {
    }

    public static boolean spawnPirateShip(BlockPos targetSpawnPoint, World world, IColony colony, String shipSize, IColonyRaidEvent event, int shipRotation) {
        CreativeRaiderStructureHandler structure = new CreativeRaiderStructureHandler(world, targetSpawnPoint, "schematics/ships/" + shipSize, new PlacementSettings(Mirror.NONE, BlockPosUtil.getRotationFromRotations(shipRotation)), true, event, colony.getID());
        return colony.getEventManager().getStructureManager().spawnTemporaryStructure(structure.getBluePrint(), "schematics/ships/" + shipSize, targetSpawnPoint, event.getID(), shipRotation, Mirror.NONE);
    }

    public static void setupSpawner(BlockPos location, World world, EntityType<?> mob, IColonyRaidEvent event, int colonyId) {
        world.func_217377_a(location, false);
        world.func_175656_a(location, Blocks.field_150474_ac.func_176223_P());
        MobSpawnerTileEntity spawner = new MobSpawnerTileEntity();
        spawner.func_145881_a().field_98289_l = 30;
        spawner.func_145881_a().func_200876_a(mob);
        spawner.func_145881_a().field_98282_f.func_185277_b().func_74768_a("mc_event_id", event.getID());
        spawner.func_145881_a().field_98282_f.func_185277_b().func_74768_a("colony", colonyId);
        event.addSpawner(location);
        world.func_175690_a(location, (TileEntity)spawner);
    }

    public static boolean canSpawnShipAt(IColony colony, BlockPos spawnPoint, int raidLevel, int rotation, String shipName) {
        if (spawnPoint.equals((Object)colony.getCenter()) || spawnPoint.func_177956_o() > (Integer)MineColonies.getConfig().getServer().maxYForBarbarians.get()) {
            return false;
        }
        World world = colony.getWorld();
        String shipSize = ShipSize.getShipForRaiderAmount((int)raidLevel).schematicPrefix + shipName;
        CreativeBuildingStructureHandler structure = new CreativeBuildingStructureHandler(colony.getWorld(), spawnPoint, "schematics/ships/" + shipSize, new PlacementSettings(), true);
        structure.getBluePrint().rotateWithMirror(BlockPosUtil.getRotationFromRotations(rotation), Mirror.NONE, colony.getWorld());
        return ShipBasedRaiderUtils.canPlaceShipAt(spawnPoint, structure.getBluePrint(), world) || ShipBasedRaiderUtils.canPlaceShipAt(spawnPoint.func_177977_b(), structure.getBluePrint(), world);
    }

    public static boolean canPlaceShipAt(BlockPos pos, Blueprint ship, World world) {
        BlockPos zeroPos = pos.func_177973_b((Vector3i)ship.getPrimaryBlockOffset());
        return ShipBasedRaiderUtils.isSurfaceAreaMostlyMaterial(Lists.newArrayList((Object[])new Material[]{Material.field_151586_h, Material.field_151588_w, Material.field_203243_f}), world, pos.func_177956_o(), zeroPos, new BlockPos(zeroPos.func_177958_n() + ship.getSizeX() - 1, zeroPos.func_177956_o(), zeroPos.func_177952_p() + ship.getSizeZ() - 1), 0.99);
    }

    public static boolean isSurfaceAreaMostlyMaterial(@NotNull List<Material> materials, @NotNull World world, int baseY, @NotNull BlockPos from, @NotNull BlockPos to, double percentRequired) {
        int xDist = Math.abs(from.func_177958_n() - to.func_177958_n());
        int zDist = Math.abs(from.func_177952_p() - to.func_177952_p());
        int wrongMaterialBlocks = 0;
        int neededMaterialBlocks = (int)(percentRequired * (double)(xDist * zDist));
        int wrongMaterialBlockThreshold = xDist * zDist - neededMaterialBlocks;
        int xDir = 1;
        int zDir = 1;
        if (from.func_177958_n() > to.func_177958_n()) {
            xDir = -1;
        }
        if (from.func_177952_p() > to.func_177952_p()) {
            zDir = -1;
        }
        for (int x = 0; x < xDist; ++x) {
            for (int z = 0; z < zDist; ++z) {
                if (materials.contains(world.func_180495_p(new BlockPos(from.func_177958_n() + x * xDir, baseY, from.func_177952_p() + z * zDir)).func_185904_a()) && world.func_175623_d(new BlockPos(from.func_177958_n() + x * xDir, baseY + 1, from.func_177952_p() + z * zDir)) || ++wrongMaterialBlocks <= wrongMaterialBlockThreshold) continue;
                return false;
            }
        }
        return true;
    }

    public static BlockPos getLoadedPositionTowardsCenter(BlockPos startPos, IColony colony, int maxDistance, BlockPos maxDistancePos, int minDistance, int accuracy) {
        if (accuracy < 1) {
            return null;
        }
        if (WorldUtil.isBlockLoaded((IWorld)colony.getWorld(), startPos)) {
            return BlockPosUtil.findAround(colony.getWorld(), startPos, 3, 30, (world, pos) -> (world.func_180495_p(pos).func_200132_m() || world.func_180495_p(pos).func_185904_a().func_76224_d()) && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && world.func_180495_p(pos.func_177981_b(2)).func_185904_a() == Material.field_151579_a);
        }
        BlockPos diff = colony.getCenter().func_177973_b((Vector3i)startPos);
        diff = new BlockPos(diff.func_177958_n() / accuracy, diff.func_177956_o() / accuracy, diff.func_177952_p() / accuracy);
        int sqMaxDist = maxDistance * maxDistance;
        int sqMinDist = minDistance * minDistance;
        BlockPos tempPos = new BlockPos((Vector3i)startPos);
        for (int i = 0; i < accuracy; ++i) {
            if (BlockPosUtil.getDistanceSquared2D(maxDistancePos, tempPos = tempPos.func_177971_a((Vector3i)diff)) > (long)sqMaxDist || BlockPosUtil.getDistanceSquared2D(tempPos, colony.getCenter()) < (long)sqMinDist) {
                return null;
            }
            if (!WorldUtil.isBlockLoaded((IWorld)colony.getWorld(), tempPos)) continue;
            return BlockPosUtil.getFloor(tempPos, colony.getWorld());
        }
        return null;
    }

    public static BlockPos findSpawnPosOnShip(BlockPos spawnPos, World world, int radius) {
        for (int y = 0; y <= radius * 2; y += 2) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (!(world.func_180495_p(spawnPos.func_177982_a(x, y, z)).func_177230_c() instanceof AirBlock) || !(world.func_180495_p(spawnPos.func_177982_a(x, y + 1, z)).func_177230_c() instanceof AirBlock)) continue;
                    return spawnPos.func_177982_a(x, y, z);
                }
            }
        }
        return spawnPos;
    }
}

